<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class UpdateRentTableAddExpireHandle extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        //
        Schema::table('rent', function (Blueprint $table) {
            $table->unsignedTinyInteger('expire_handle')->default(0)->comment('是否做过期处理');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
        Schema::table('rent', function (Blueprint $table) {
            $table->dropColumn('expire_handle');
        });
    }
}
