<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSpotIdAndBusinessIdToProductionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('production', function (Blueprint $table) {
            //
            $table->unsignedInteger('spot_id')->comment('景点id');
            $table->unsignedInteger('business_id')->comment('商家id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('production', function (Blueprint $table) {
            //
            $table->dropColumn('spot_id');
            $table->dropColumn('business_id');

        });
    }
}
