<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRepairsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('repairs', function (Blueprint $table) {
            $table->increments('id');
            $table->Integer('spot_id')->unsigned()->comment('景点ID');
            $table->Integer('machine_id')->unsigned()->comment('机柜ID');
            $table->Integer('system_users_id')->unsigned()->comment('商家账号ID');
            $table->text('remark')->nullable()->comment('问题描述');
            $table->string('tel')->nullable()->comment('联系方式');
            $table->Integer('status')->unsigned();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('repairs');
    }
}
