<?php
/**
 * Created by PhpStorm.
 * User: machengjun
 * Date: 2018/3/12
 * Time: 下午6:27
 */
Route::group([
    'namespace' => 'Business',
    'prefix'  => 'business',
    'as' => 'business.'
], function() {

    Route::post('/login', 'BusinessController@login')->name('login');
    Route::post('/refresh/token', 'BusinessController@refreshToken')->name('refresh_token');
    Route::group([
        'middleware' => 'business'
    ], function() {

        Route::post('/index', 'ReportController@index')->name('index');
        Route::post('/chart', 'ReportController@chart')->name('chart');
        Route::post('/spot/rent/over/record', 'ReportController@rentOverRecord')->name('spot_rent_record');
        Route::post('/spot/guide/record', 'ReportController@guideRecord');

        Route::post('/spot/rent/list', 'RentController@rentList');
        Route::post('/spot/rent/Detail', 'RentController@rentDetail');



        Route::post('/spot/profile', 'SpotController@profile');
        Route::post('/spot/list', 'SpotController@mySpotList')->name('/spot_list');
        Route::post('/spot/change/selected', 'SpotController@changeSpotSelected')->name('/spot_change_selected');

        Route::post('/spot/machine', 'MachineController@getSpotMachine');
        Route::post('/spot/repair', 'CommunicationController@repairCreate');



    });
});