<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 10/02/2018
 * Time: 2:47 PM
 */
namespace App\Common\TencentMQ;


use Illuminate\Support\Facades\Log;

class HttpProducer
{
    private $host;
    private $secretId;
    private $secretKey;

    /*
        @type host: string
        @param host: 访问的url，例如：https://cmq-queue-gz.api.qcloud.com

        @type secretId: string
        @param secretId: 用户的secretId, 腾讯云官网获取

        @type secretKey: string
        @param secretKey:  用户的secretKey，腾讯云官网获取

        @note: Exception
        :: CMQClientParameterException host格式错误
    */

    public function __construct($host, $secretId, $secretKey) {
        $this->host = $host;
        $this->secretId = $secretId;
        $this->secretKey = $secretKey;
        $this->cmq_client = new CMQClient($host, $secretId, $secretKey);
    }


    public function sendMessage($queueName, $messageBody, $delay = 0) {

        $account = new Account($this->host, $this->secretId, $this->secretKey);

        $queue = $account->get_queue($queueName);

        $msg = new Message($messageBody);
        $re_msg = $queue->send_message($msg, $delay);

        Log::info('ret_msg is'.json_encode($re_msg));

        return $re_msg;
    }
}