<?php
/**
 * Created by PhpStorm.
 * User: machengjun
 * Date: 2018/3/12
 * Time: 下午5:23
 */
namespace App\Http\Controllers\Api\Business;
use App\Http\Controllers\Controller;
use App\Http\Requests\Business\Api\BusinessLoginRequest;
use App\Repositories\Business\BusinessRepository;
use App\Repositories\CustomerRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

/**
 * Class CustomerController
 * @package App\Http\Controllers\Api
 */
class BusinessController extends Controller
{

    protected $business;

    public function __construct(BusinessRepository $business)
    {
        $this->business = $business;
    }


    public function login(BusinessLoginRequest $request)
    {
        Log::info("[businessLogin]params" . json_encode($request->all()));


        $response = $this->business->login($request->only("username", "password"));


        return $this->responseSuccess($response);
    }



    public function refreshToken()
    {
        $response = $this->business->refreshToken();

        return $this->responseSuccess($response);
    }


}