<?php

namespace App\Http\Requests\Business\Api;


use App\Http\Requests\ApiBaseRequest;

/**
 * Class CustomerLoginRequest.
 * @package App\Http\Requests\Customer
 */
class BusinessLoginRequest extends ApiBaseRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'username'             => 'required|max:191',
            'password'              => 'required',
        ];
    }
}
