<?php

namespace App\Http\Requests\Customer\Api;

use App\Common\RegExpPattern;

use App\Http\Requests\ApiBaseRequest;

/**
 * Class StoreCustomerRequest.
 * @package App\Http\Requests\Customer
 */
class StoreCustomerRequest extends ApiBaseRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'telephone'             => 'required|unique:customers|regex:'.RegExpPattern::REGEX_MOBILE,
            'sms'                   => 'required|sms_verify',
            'type'                  => 'required',
            'password'              => 'required|alpha_num|min:6|confirmed',
            'password_confirmation' => 'required|alpha_num|min:6',
        ];
    }
}
