<?php

namespace App\Modules\Models\Machine;

use App\Modules\Models\Create_num\Create_num;
use App\Modules\Models\Machine\Traits\Relationship\MachineRelationship;
use App\Modules\Models\Machine\Traits\Attribute\MachineAttribute;
use Grimzy\LaravelMysqlSpatial\Eloquent\SpatialTrait;
use Illuminate\Database\Eloquent\Model;

class Machine extends Model
{
    use SpatialTrait;
    use MachineRelationship ,MachineAttribute;
    //
    protected $table = 'machine';

    protected $fillable = ['mac_no', 'he_cloud_device_id','one_day_price', 'deposit', 'address','free_time', 'position',  'spot_id', 'business_id', 'wx_mini_program', 'ali_mini_program','type','hatch_number'];

    protected $hidden = [];


    protected function num()
    {
        $date=date("ymdhi");
        $id=Create_num::add();
        $num=800000;
        return  $date.($num+$id);

    }
    protected $spatialFields = [
        'position',
    ];
}
