<?php

namespace App\Modules\Models\Machine\Traits\Relationship;

use App\Modules\Models\Power\Power;
use App\Modules\Models\Spot\Spot;

/**
 * Class BaseCustomerRelationship
 * @package App\Modules\Models\Customer\Traits\Relationship
 */
trait MachineRelationship
{
    /**
     * Consume Order Relation
     *@return mixed
     */
    public function power()
    {
        return $this->hasMany(Power::class);
    }

    public function spot()
    {
        return $this->belongsTo(Spot::class,'spot_id','id');
    }

    public function availableNumber(){
        $where = [
            ['status','=','2'],
            ['has_power','>',30]
        ];
        return $this->hasMany(Power::class)->where($where);
    }

}