<?php
/**
 * Created by PhpStorm.
 * User: machengjun
 * Date: 2018/2/9
 * Time: 下午1:43
 */

namespace App\Modules\Models\Rent\Traits\Relationship;

use App\Modules\Models\Customer\Customer;
use App\Modules\Models\Machine\Machine;
use App\Modules\Models\Order\CouponShip;
use App\Modules\Models\Production\Production;
use App\Modules\Models\Spot\Spot;


/**
 * Class BaseCustomerRelationship
 * @package App\Modules\Models\Customer\Traits\Relationship
 */
trait RentRelationship
{


    public function production()
    {
        return $this->hasMany(Production::class);

    }

    public function spot()
    {
        return $this->belongsTo(Spot::class,'spot_id','id');

    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);

    }
    public function machine()
    {
        return $this->belongsTo(Machine::class);

    }

    public function consumeOrders()
    {
        return $this->hasMany(CouponShip::class,'order_id');

    }



}