<?php
/**
 * Created by PhpStorm.
 * User: machengjun
 * Date: 2018/2/9
 * Time: 下午1:43
 */

namespace App\Modules\Models\RentTest\Traits\Relationship;

use App\Modules\Models\CustomerTest\CustomerTest;
use App\Modules\Models\Machine\Machine;
use App\Modules\Models\Order\CouponShip;
use App\Modules\Models\ProductionTest\ProductionTest;
use App\Modules\Models\Spot\Spot;


/**
 * Class BaseCustomerRelationship
 * @package App\Modules\Models\Customer\Traits\Relationship
 */
trait RentTestRelationship
{


    public function production()
    {
        return $this->hasMany(ProductionTest::class);

    }

    public function spot()
    {
        return $this->belongsTo(Spot::class,'spot_id','id');

    }

    public function customer()
    {
        return $this->belongsTo(CustomerTest::class);

    }
    public function machine()
    {
        return $this->belongsTo(Machine::class);

    }

    public function consumeOrders()
    {
        return $this->hasMany(CouponShip::class,'order_id');

    }



}