<?php
/**
 * Created by PhpStorm.
 * User: machengjun
 * Date: 2018/3/22
 * Time: 下午5:50
 */
namespace App\Modules\Models\Repairs\Traits\Relationship;

use App\Modules\Models\Spot\Spot;
use App\Modules\Models\Machine\Machine;
use App\Modules\Models\RepairImages\RepairImages;

/**
 * Class FeedbackRelationship
 * @package App\Modules\Models\Feedback\Traits\Relationship
 */
trait RepairsRelationship
{
    /**
     * @return mixed
     */

    public function spot()
    {
        return $this->belongsTo(Spot::class);
    }

    public function machine()
    {
        return $this->belongsTo(Machine::class);
    }

    /**
     * @return mixed
     */
    public function images()
    {
        return $this->hasMany(RepairImages::class, 'repairs_id', 'id');
    }
}