<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 01/09/2017
 * Time: 5:30 PM
 */

namespace App\Modules\Onenet\Message;

use App\Modules\Enums\ErrorCode;
use App\Exceptions\Api\ApiException;


/**
 * Class ReceiveMessage
 * @package App\Modules\Onenet\Message
 */
abstract class ReceiveMessage extends Message
{
    /**
     * @var string
     */
    private $msgType;

    /**
     * @var string
     */
    private $dataStream;

    /**
     * CommandMessage constructor.
     * @param $deviceId
     * @param $msgType
     * @param $dataStream
     */
    public function __construct($deviceId, $msgType, $dataStream)
    {
        parent::__construct($deviceId);
        $this->msgType = $msgType;
        $this->dataStream = $dataStream;
    }

    /**
     * @return string
     */
    public function getMsgType()
    {
        return $this->msgType;
    }

    /**
     * @param string $msgType
     */
    public function setMsgType($msgType)
    {
        $this->msgType = $msgType;
    }

    /**
     * @return string
     */
    public function getDataStream()
    {
        return $this->dataStream;
    }

    /**
     * @param string $dataStream
     */
    public function setDataStream($dataStream)
    {
        $this->dataStream = $dataStream;
    }

    /**
     * pack message to send to onenet
     * @throws ApiException
     */
    public function pack()
    {
        throw new ApiException(ErrorCode::PACK_NOT_DEFINED, trans('api.error.param_error'));
    }
}