<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 20/03/2017
 * Time: 6:23 PM
 */

namespace App\Modules\Onenet\Message\ReceiveMessage;

use App\Common\Byte;
use App\Modules\Onenet\Message\MsgType;
use App\Modules\Onenet\Message\ReceiveMessage;
use Illuminate\Support\Facades\Log;

class BatteryOperationMessage extends ReceiveMessage
{
    /**
     * @var int
     */
    private $remark_stanza = 0;

    /**
     * @var int
     */
    private $time_stanza = 0;

    /**
     * @var int
     */
    private $position_stanza = 3;

    /**
     * @var
     */
    private $battery_sn;

    /**
     * @var
     */
    private $battery_position;

    /**
     * @var
     */
    private $time;

    /**
     * @param $deviceId
     * @param $dataStreamType
     * TakeOutMessage constructor.
     */
    public function __construct($deviceId, $dataStreamType)
    {
        parent::__construct($deviceId, MsgType::DATASTREAM_TYPE, $dataStreamType);
    }

    /**
     * @return int
     */
    protected function getStanzaLength()
    {
        return config('constants.battery.sn_length') + $this->time_stanza + $this->remark_stanza + $this->position_stanza;
    }

    /**
     * @return int
     */
    public function getRemarkStanza()
    {
        return $this->remark_stanza;
    }

    /**
     * @param int $remark_stanza
     */
    public function setRemarkStanza($remark_stanza)
    {
        $this->remark_stanza = $remark_stanza;
    }

    /**
     * @return int
     */
    public function getTimeStanza()
    {
        return $this->time_stanza;
    }

    /**
     * @param int $time_stanza
     */
    public function setTimeStanza($time_stanza)
    {
        $this->time_stanza = $time_stanza;
    }

    /**
     * @return mixed
     */
    public function getBatterySn()
    {
        return $this->battery_sn;
    }

    /**
     * @param mixed $battery_sn
     */
    public function setBatterySn($battery_sn)
    {
        $this->battery_sn = $battery_sn;
    }

    /**
     * @return mixed
     */
    public function getTime()
    {
        return $this->time;
    }

    /**
     * @param mixed $time
     */
    public function setTime($time)
    {
        $this->time = $time;
    }

    /**
     * @return mixed
     */
    public function getBatteryPosition()
    {
        return $this->battery_position;
    }

    /**
     * @param mixed $battery_position
     */
    public function setBatteryPosition($battery_position)
    {
        $this->battery_position = $battery_position;
    }

    protected function unpackInternal($msg)
    {
        $this->battery_sn = substr($msg, 0, config('constants.battery.sn_length'));
        $i = config('constants.battery.sn_length');

        $byte = intval(substr($msg, $i, $this->position_stanza));
        $this->battery_position = $byte+1;
        $i += $this->position_stanza;

        $this->time = date('Y-m-d H:i:s');
//        $this->time = $this->handleTimeStanza($msg, $i, $this->time_stanza);
    }

    /**
     * @param $msg
     */
    public function unpack($msg)
    {

        if (strlen($msg) != $this->getStanzaLength())
        {
            Log::error("[unpack] stanza size incorrect! received size:".strlen($msg).", actual size:".$this->getStanzaLength());
            return;
        }

        $this->unpackInternal($msg);
//        $this->time = $this->handleTimeStanza($msg, $i, $this->time_stanza);
    }
}