<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 18/03/2017
 * Time: 9:47 AM
 */

namespace App\Modules\Onenet\Message\ReceiveMessage;


use App\Modules\Onenet\Enum\DataStreams;
use App\Modules\Onenet\Message\MsgType;
use App\Modules\Onenet\Message\ReceiveMessage;

class SellStateMessage extends ReceiveMessage
{
    /**
     * @var
     */
    private $firstStorageStatus;
    
    /**
     * @var
     */
    private $secondStorageStatus;
    /**
     * @param $deviceId
     * ConnectMessage constructor.
     */
    public function __construct($deviceId)
    {
        parent::__construct($deviceId, MsgType::DATASTREAM_TYPE, DataStreams::SELL_STATE);
    }

    /**
     * @return mixed
     */
    public function getFirstStorageStatus()
    {
        return $this->firstStorageStatus;
    }

    /**
     * @param mixed $firstStorageStatus
     */
    public function setFirstStorageStatus($firstStorageStatus)
    {
        $this->firstStorageStatus = $firstStorageStatus;
    }

    /**
     * @return mixed
     */
    public function getSecondStorageStatus()
    {
        return $this->secondStorageStatus;
    }

    /**
     * @param mixed $secondStorageStatus
     */
    public function setSecondStorageStatus($secondStorageStatus)
    {
        $this->secondStorageStatus = $secondStorageStatus;
    }

    private function getStorageStatus($value)
    {
        $storage = explode('=', $value);

        if (count($storage) != 2)
        {
            return -1;
        }
        else
        {
            return $storage[1];
        }
    }

    public function unpack($msg)
    {
        $status_array = explode('|', $msg);

        if (count($status_array) != 2)
        {
            return false;
        }
        else
        {
            $storage1 = $this->getStorageStatus($status_array[0]);
            $storage2 = $this->getStorageStatus($status_array[1]);


            if ($storage1 == -1 || $storage2 == -1)
            {
                return false;
            }

            $this->setFirstStorageStatus($storage1);
            $this->setSecondStorageStatus($storage2);
        }

        return true;
    }
}