<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 01/09/2017
 * Time: 5:30 PM
 */

namespace App\Modules\Onenet\Message\ReceiveMessage;

use App\Modules\Onenet\Enum\DataStreams;
use App\Modules\Onenet\Message\MsgType;
use App\Modules\Onenet\Message\ReceiveMessage;


/**
 * Class VersionMessage
 * @package App\Modules\Onenet\Message
 */

class VersionMessage extends ReceiveMessage
{
    private $version;

    /**
     * CommandMessage constructor.
     * @param $deviceId
     */
    public function __construct($deviceId)
    {
        parent::__construct($deviceId, MsgType::DATASTREAM_TYPE, DataStreams::VERSION);
    }

    /**
     * @return mixed
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * @param mixed $version
     */
    public function setVersion($version)
    {
        $this->version = $version;
    }

    public function unpack($value)
    {
        $this->setVersion($value);
    }
}