<?php

namespace App\Modules\Repositories;

/**
 * Class BaseRepository.
 */
use App\Exceptions\GeneralException;
use YueCode\Cos\QCloudCos;

class BaseRepository
{
    /**
     * @return mixed
     */
    public function getAll()
    {
        return $this->query()->where('auto_send', 0)->get();
    }

    /**
     * @return mixed
     */
    public function getCount()
    {
        return $this->query()->count();
    }

    /**
     * @param $id
     *
     * @return mixed
     */
    public function find($id)
    {
        return $this->query()->find($id);
    }

    /**
     * @return mixed
     */
    public function query()
    {
        return call_user_func(static::MODEL . '::query');
    }



    //上传音频文件按
     public function audio()
     {
        
         $allow_file_type =['mp3','mp4'];

         if(!$_FILES||!$_FILES['audio_url']){

             throw new GeneralException(trans('exceptions.backend.explain_info.create_error'));  //请选上传文件
         }
         $file_name = $_FILES['audio_url']['name'];
         $tmp_file_extend =  explode('.',$file_name);   //mp3
         if(!in_array(strtolower(end($tmp_file_extend)),$allow_file_type)) {

             throw new GeneralException(trans('exceptions.backend.explain_info.type_error'));     // '请选择指定上传的音频类型'
         }
         //限制音频大小
         if($_FILES['audio_url']['size']>25004900){
             
             throw new GeneralException(trans('exceptions.backend.explain_info.size_error'));// '请选择指定上传的大小'
         }
         //上传cdn
         $num =md5(uniqid());
         $path ="/audio/".$num.".mp3";
         $dd=QCloudCos::upload('dev',$_FILES['audio_url']['tmp_name'],$path);
         if($dd){
             $info =json_decode($dd,true);
             $info['path'] =$path;
             $info['size'] =$_FILES['audio_url']['size'];
             return $info ;
         } else{
             throw new GeneralException(trans('exceptions.backend.explain_info.cos_error'));
             return  false;
         }

     }



     public function imgup($backet)
     {
          $allow_file_type =['jpg','png','gif','jpeg'];

         if(!$_FILES||!$_FILES[$backet]){
             throw new GeneralException(trans('exceptions.backend.explain_info.upload_error'));  //请选上传文件

         }
         $file_name = $_FILES[$backet]['name'];
         $tmp_file_extend =  explode('.',$file_name);
         if(!in_array(strtolower(end($tmp_file_extend)),$allow_file_type)) {
             throw new GeneralException(trans('exceptions.backend.explain_info.type_error'));     // '请选择指定上传的图片类型'
         }

         if($_FILES[$backet]['size']>1502480)
         {
             throw new GeneralException(trans('exceptions.backend.explain_info.size_error'));// '请选择指定上传的大小'
         }
         //上传cdn
         $num =md5(uniqid());
         $path ="/img/".$num.".png";
         $dd=QCloudCos::upload('dev',$_FILES[$backet]['tmp_name'],$path);
         if($dd){
             $info =json_decode($dd,true);
             $info['path'] =$path;
             $info['size'] =$_FILES[$backet]['size'];
             return $info ;
         } else{
             throw new GeneralException(trans('exceptions.backend.explain_info.cos_error'));
             return  false;
         }

     }


}





