<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 10/04/2017
 * Time: 11:31 AM
 */

namespace App\Providers;

use App\Common\Sms;
use App\Modules\Enums\ErrorCode;
use App\Exceptions\Api\ApiException;
use App\Modules\Models\Customer\Customer;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Auth\UserProvider as IlluminateUserProvider;
use Illuminate\Support\Str;

class CustomerUserProvider implements IlluminateUserProvider
{
    /**
     * The Eloquent user model.
     *
     * @var string
     */
    protected $model;

    /**
     * CustomerUserProvider constructor.
     * @param string $model
     */
    public function __construct($model)
    {
        $this->model = $model;
    }

    /**
     * Create a new instance of the model.
     *
     * @return \Illuminate\Database\Eloquent\Model
     */
    public function createModel()
    {
        $class = '\\'.ltrim($this->model, '\\');

        return new $class;
    }

    public function getModel()
    {
        return Customer::class;
    }

    /**
     * Retrieve a user by their unique identifier.
     *
     * @param  mixed $identifier
     * @return \Illuminate\Contracts\Auth\Authenticatable|null
     */
    public function retrieveById($identifier)
    {
        return Customer::find($identifier);
    }

    /**
     * Retrieve a user by their unique identifier and "remember me" token.
     *
     * @param  mixed $identifier
     * @param  string $token
     * @return \Illuminate\Contracts\Auth\Authenticatable|null
     */
    public function retrieveByToken($identifier, $token)
    {
        return null;
    }

    /**
     * Update the "remember me" token for the given user in storage.
     *
     * @param  \Illuminate\Contracts\Auth\Authenticatable $user
     * @param  string $token
     * @return void
     */
    public function updateRememberToken(Authenticatable $user, $token)
    {
        // TODO: Implement updateRememberToken() method.
    }

    /**
     * Retrieve a user by the given credentials.
     *
     * @param  array $credentials
     * @return \Illuminate\Contracts\Auth\Authenticatable|null
     */
    public function retrieveByCredentials(array $credentials)
    {
        if (empty($credentials)) {
            return null;
        }

        // First we will add each credential element to the query as a where clause.
        // Then we can execute the query and, if we found a user, return it in a
        // Eloquent User "model" that will be utilized by the Guard instances.
        $query = $this->createModel()->newQuery();

        foreach ($credentials as $key => $value) {
            if (! Str::contains($key, 'password') && ! Str::contains($key, 'sms')) {
                $query->where($key, $value);
            }
        }

        return $query->first();
    }

    /**
     * Validate a user against the given credentials.
     *
     * @param Authenticatable $user
     * @param array $credentials
     * @return bool
     * @throws ApiException
     */
    public function validateCredentials(Authenticatable $user, array $credentials)
    {
        if ($user->status == 0)
        {
            throw new ApiException(ErrorCode::USER_DISABLED, trans('api.error.user_disabled'));
        }

        if (isset($credentials['sms']))
        {
            $telephone = $user->telephone;
            $sms = $credentials['sms'];

            //For app store verify
            if (config('constants.app_store.hack_on') && $telephone == config('constants.app_store.hack_telephone') && $sms == config('constants.app_store.hack_sms'))
            {
                return true;
            }

            return Sms::verifyCode($telephone, $sms);
        }
        else if (isset($credentials['mini_program_open_id']) || isset($credentials['openid']))
        {
            return true;
        }
        else
        {
            $password = $credentials['password'];
            return password_verify($password, $user->password);
        }
    }
}