<?php

namespace App\Repositories\Business;

use App\Modules\Models\GuideRecord\GuideRecord;
use App\Modules\Repositories\BaseRepository;


/**
 * Class SpotRepository
 * @package App\Repositories\Spot
 */
class GuideRepository extends BaseRepository
{

    public function getSpotGuideRecord($spot_id, $page, $limit, $search)
    {
        $where = [
            ['spot_id', '=', $spot_id],
            ['is_pay', '=', 1]
        ];
        if (isset($search['day'])) {
            $where[] = ['pay_time', '>=', $search['day'] . ' 00:00:00'];
            $where[] = ['pay_time', '<=', $search['day'] . ' 23:59:59'];
        }

        if (isset($search['month'])) {
            $start_time = $search['month'] . '-01 00:00:00';
            $end_time = date('Y-m', strtotime("+1 month {$search['month']}")) . '-01 00:00:00';
            $where[] = ['pay_time', '>=', $start_time];
            $where[] = ['pay_time', '<=', $end_time];
        }
        return GuideRecord::where($where)->orderBy('pay_time', 'desc')->skip($page * $limit)->take($limit)->get();

    }

    public function getTodayIncome($spot_id)
    {
        $start_time = date('Y-m-d') . ' 00:00:00';
        $end_time = date('Y-m-d') . ' 23:59:59';
        $where = [
            ['is_pay', '=', 1],
            ['spot_id', '=', $spot_id],
            ['pay_time', '>', $start_time],
            ['pay_time', '<=', $end_time],
        ];
        $rent_total = GuideRecord::where($where)->sum('real_total');
        return $rent_total;
    }

    public function getThisMonthIncome($spot_id)
    {
        $time = date('Y-m', time());
        $start_time = $time . '-01 00:00:00';
        $end_time = date('Y-m-d H:i:s');
        $where = [
            ['is_pay', '=', 1],
            ['spot_id', '=', $spot_id],
            ['pay_time', '>', $start_time],
            ['pay_time', '<=', $end_time],
        ];
        $rent_total = GuideRecord::where($where)->sum('real_total');
        return $rent_total;

    }


    public function guideFinish($spot_id)
    {
        $where = [
            ['is_pay', '=', 1],
            ['spot_id', '=', $spot_id],
        ];
        $number = GuideRecord::where($where)->count();
        return $number;
    }
}
