<?php

namespace App\Repositories\Business;

use App\Exceptions\Api\ApiException;
use App\Modules\Enums\ErrorCode;
use App\Modules\Models\Machine\Machine;
use App\Modules\Repositories\BaseRepository;


/**
 * Class EloquentHistoryRepository.
 */
class MachineRepository extends BaseRepository
{

    function getSpotMachine($spot_id)
    {

        $where = [
            ['spot_id', '=', $spot_id]
        ];
        $machines_obj = Machine::where($where)->withCount('availableNumber as available_number')->get();
        if ($machines_obj == null) {
            throw new ApiException(ErrorCode::SPOT_DO_NOT_HAS_MACHINE, trans('api.error.spot_do_not_has_machine'));
        }
        return $machines_obj;

    }


    function getSpotMachineList($spot_id)
    {
        $where = [
            ['spot_id', '=', $spot_id]
        ];
        $machines_obj = Machine::where($where)->get();
        return $machines_obj;
    }


}
