<?php

namespace App\Repositories\Business;

use App\Exceptions\Api\ApiException;
use App\Modules\Enums\ErrorCode;
use App\Modules\Models\DayIncome\DayIncome;
use App\Modules\Models\DayIncomeTest\DayIncomeTest;
use App\Modules\Models\Settlement\Finance;
use App\Modules\Models\SettlementTest\FinanceTest;
use App\Modules\Repositories\BaseRepository;


/**
 * Class SpotRepository
 * @package App\Repositories\Spot
 */
class ReportRepository extends BaseRepository
{
    public function getSpotDayIncome($start_date, $end_date, $spot_id)
    {
        $where = [
            ['day', '>=', $start_date],
            ['day', '<=', $end_date],
            ['spot_id', '=', $spot_id],
        ];
        return DayIncome::where($where)->get();
    }

    public function getSpotDayIncomeTest($start_date, $end_date, $spot_id)
    {
        $where = [
            ['day', '>=', $start_date],
            ['day', '<=', $end_date],
            ['spot_id', '=', $spot_id],
        ];
        return DayIncomeTest::where($where)->get();
    }


    public function getSpotMonthIncome($start_month, $end_month, $spot_id)
    {
        $where = [
            ['month', '>=', $start_month],
            ['month', '<=', $end_month],
            ['spot_id', '=', $spot_id],
        ];

        return Finance::where($where)->get();

    }

    public function getSpotMonthIncomeTest($start_month, $end_month, $spot_id)
    {
        $where = [
            ['month', '>=', $start_month],
            ['month', '<=', $end_month],
            ['spot_id', '=', $spot_id],
        ];

        return FinanceTest::where($where)->get();

    }

    public function getSpotRentInMonthIncomeTotal($month,$spot_id)
    {
        $month = str_replace('-','',$month);
        $where = [
            ['month', '=', $month],
            ['spot_id', '=', $spot_id],
        ];

        $finance = Finance::where($where)->first();
        if($finance == null){
            throw new ApiException(ErrorCode::FINANCE_NOT_EXIST,trans('api.error.finance_not_exist'));
        }
        return $finance->total;
    }


    public function getSpotGuideInMonthIncomeTotal($month,$spot_id){
        $where = [
            ['month', '=', $month],
            ['spot_id', '=', $spot_id],
        ];

        $finance = Finance::where($where)->first();
        if($finance == null){
            throw new ApiException(ErrorCode::FINANCE_NOT_EXIST,trans('api.error.finance_not_exist'));
        }
        return $finance->guide_total;
    }


}
