<?php

namespace App\Repositories\Customers;


use App\Modules\Enums\ErrorCode;
use App\Modules\Repositories\BaseRepository;
use Illuminate\Support\Facades\Redis;
use Qcloud\Sms\SmsSingleSender;

class SMSRepository extends BaseRepository
{

    protected $appid;
    protected $appkey;

    static protected $ssender = null;

    function __construct()
    {
        $this->appid = config('sms.appid');
        $this->appkey = config('sms.appkey');
        if (self::$ssender == null) {
            try {
                self::$ssender = new SmsSingleSender($this->appid, $this->appkey);
            } catch (\Exception $e) {
                throw new ApiException(ErrorCode::SMS_SEND_FAIL, trans('api.error.sms_send_fail'));
            }
        }

    }

    /**
     * @param $phoneNumber
     * @return string
     * sendWithParam($nationCode, $phoneNumber, $templId = 0, $params,
     * $sign = "", $extend = "", $ext = "")
     */
    function phoneSendCode($phoneNumber, $templId = 91237, $sign = '灰兔智能')
    {
        $code = $this->makeCode($phoneNumber);
        $params = [
            "$code"
        ];
        try {
            $res = self::$ssender->sendWithParam(86, $phoneNumber, $templId, $params, $sign, '', '');
        } catch (\Exception $e) {
            throw new ApiException(ErrorCode::SMS_SEND_FAIL, trans('api.error.sms_send_fail'));
        }
        return $res;
    }

    function create_code($length = 4)
    {
        $key = '';
        for ($i = 0; $i < $length; $i++) {
            $key .= mt_rand(0, 9);
        }
        return $key;
    }

    /**
     * @param $phoneNumber
     * @return string
     */
    function makeCode($phoneNumber)
    {
        $code = $this->create_code(4);
        Redis::setex($phoneNumber, 300, $code);
        return $code;
    }
}