<?php
/**
 * Created by PhpStorm.
 * User: billy
 * Date: 13/04/2017
 * Time: 2:22 PM
 */

namespace App\Modules\Util;


use App\Common\Jpush;
use App\Modules\Enums\PushSubType;
use App\Modules\Enums\WebsocketType;
use GatewayClient\Gateway;
use Illuminate\Support\Facades\Log;
use Monolog\Logger;

/**
 * Class PushUtil
 * @package App\Modules\Util
 */
class PushUtil
{
    private static function getPushedMessage($type)
    {
        $msg = '';
        switch ($type) {
            case WebsocketType::POWER_TAKE_OUT_SUCCESS:
                $msg = trans('api.success.shipment_success');
                break;
            case WebsocketType::POWER_TAKE_OUT_FAIL:
                $msg = trans('api.success.shipment_fail');
                break;
            case WebsocketType::SUBSCRIBE_FAIL:
                $msg = trans('api.success.subscribe_fail');
                break;
            case WebsocketType::SUBSCRIBE_SUCCESS:
                $msg = trans('api.success.subscribe_success');
                break;
            default:
                break;
        }
        return $msg;
    }

    /**
     * @param $customer_id
     * @param $params
     */
    public static function pushWebsocketMessage($customer_id, $params)
    {

        Gateway::$registerAddress = config('constants.websocket.server', '127.0.0.1:1238');

        $params['msg'] = self::getPushedMessage($params['type']);

        Gateway::sendToUid($customer_id, json_encode($params));

    }
}
