<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->increments('id');
            $table->string('mini_program_open_id')->nullable()->comment('微信支付宝小程序openID');
            $table->string("openid")->nullable()->comment('微信支付宝公众平台openID');
            $table->string("unionid")->nullable()->comment('微信支付宝unionid');
            $table->tinyInteger("platform")->default(0)->comment('平台1微信2支付宝');
            $table->string("phone")->nullable()->comment('手机号');
            $table->integer("deposit")->default(0)->comment('押金');
            $table->string("language")->comment('语种');
            $table->string('nick_name')->nullable()->comment('昵称');
            $table->tinyInteger('gender')->default(0)->comment('性别');
            $table->string('avatar_url')->nullable()->comment('头像');
            $table->tinyInteger('status')->comment('状态0停用1正常');
            $table->timestamp("last_login_at")->nullable()->comment('上次登录时间');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customers');
    }
}
