<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMachineTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('machine', function (Blueprint $table) {
            $table->increments('id');
            $table->char('mac_no', 16)->comment('机柜编号');
            $table->string('he_cloud_device_id')->comment('机柜号对应的玻所的的编号');
            $table->integer('one_day_price')->deafult(0)->unsigned()->comment('日租金');
            $table->integer('deposit')->default(19900)->unsigned()->comment('押金');
            $table->integer('free_time')->default(0)->unsigned()->comment('免费时间');
            $table->point('position')->nullable()->comment('机柜位置坐标');
            $table->string('address')->nullable()->comment('机柜位置');
            $table->integer('spot_id')->unsigned();
            $table->integer('business_id')->unsigned();
            $table->string("wx_mini_program")->comment('微信租借二维码地址');
            $table->string("ali_mini_program")->comment('支付宝租借二维码地址');
            $table->string("version")->nullable()->comment('版本号');
            $table->string("iccid")->nullable()->comment('iccid');
            $table->tinyInteger('life')->default(0)->unsigned()->comment('机柜在线状态默认0不在线1在线');
            $table->tinyInteger('type')->default(1)->unsigned()->comment('机柜类型');
            $table->tinyInteger('hatch_number')->default(9)->unsigned()->comment('机柜的仓口数量');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('machine');
    }
}
