<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateWxGuide extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('wx_guide', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->nullable()->comment('领取的导游id');
            $table->string('qrcode')->comment('优惠二维码');
            $table->integer('spot_id')->comment('景点id');
            $table->integer('coupon_type_id')->comment('优惠券类型id');
            $table->integer('business_id')->comment('商户id');
            $table->timestamp('expire_time')->comment('活动截止时间');
            $table->integer('number')->comment('优惠群个数');
            $table->integer('old')->comment('区分老旧数据');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('wx_guide');
    }
}
