<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCouponOrder extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupon_order', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('spot_id')->nullable()->comment(' 景点id');
            $table->integer('business_id')->nullable()->comment('商户id');
            $table->integer('coupon_type_id')->comment('优惠券id');
            $table->integer('wx_guide_id')->nullable()->comment('对应导游的id');
            $table->integer('customer_id')->comment('用户的id');
            $table->integer('status')->default(0)->comment('领取的状态 1代表领取 2代表使用过 3过期');
//            $table->integer('old')->nullable()->comment('区分老旧数据');
            $table->timestamp('add_time')->comment('用户领取时间');
            $table->date('expire_time')->comment('优惠的过期时间');
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupon_order');
    }
}
