<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRedpackTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('redpack', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('send_list_id')->comment('发送成功后的微信返回的编号');
            $table->integer('money')->comment('发送的钱');
            $table->integer('user_id')->comment('导游的id');
            $table->string('order_no')->comment('对应的红包单号');
            $table->integer('Wx_guide_id')->comment('对应导游的二维码');
            $table->string('status')->comment('对应的状态');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('redpack');
    }
}
