<?php

use Database\TruncateTable;
use Carbon\Carbon as Carbon;
use Illuminate\Database\Seeder;
use Database\DisableForeignKeys;
use Illuminate\Support\Facades\DB;

/**
 * Class UserTableSeeder.
 */
class UserTableSeeder extends Seeder
{
    use DisableForeignKeys, TruncateTable;

    /**
     * Run the database seed.
     *
     * @return void
     */
    public function run()
    {
        $this->disableForeignKeys();
        $this->truncateMultiple([config('access.users_table')]);

        //Add the master administrator, user id of 1
        $users = [
            [
                'username'          => 'admin',
                'first_name'        => 'Admin',
                'last_name'         => 'Istrator',
                'password'          => bcrypt('1234'),
                'business_id'       =>0,
                'science_id'     =>0,
                'created_at'        => Carbon::now(),
                'updated_at'        => Carbon::now(),
            ],
            [
                'username'          => 'backend',
                'first_name'        => 'Backend',
                'last_name'         => 'User',
                'business_id'       =>0,
                'science_id'     =>0,
                'password'          => bcrypt('1234'),
                'created_at'        => Carbon::now(),
                'updated_at'        => Carbon::now(),
            ],
            [
                'username'          => 'default',
                'first_name'        => 'Default',
                'last_name'         => 'User',
                'business_id'       =>0,
                'science_id'     =>0,
                'password'          => bcrypt('1234'),
                'created_at'        => Carbon::now(),
                'updated_at'        => Carbon::now(),
            ],
        ];

        DB::table(config('access.users_table'))->insert($users);

        $this->enableForeignKeys();
    }
}
