# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, DateTime, String
from Model.Base import BaseModel


class WxGuide(BaseModel):
    __tablename__ = 'wx_guide'

    id = Column(Integer, primary_key=True)
    user_id = Column(Integer, comment='领取的导游id')
    qrcode = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, unique=True, comment='优惠二维码')
    spot_id = Column(Integer, nullable=False, comment='景点id')
    coupon_type_id = Column(Integer, nullable=False, comment='优惠券类型')
    business_id = Column(Integer, nullable=False, comment='商户id')
    expire_time = Column(Integer, nullable=False, comment='活动截止时间')
    bonus = Column(Integer, comment='提成')
    number = Column(Integer, comment='优惠群个数')
    old = Column(Integer, nullable=False, comment='区分老旧数据')
