# -*- coding: utf-8 -*-
import base64
import datetime

from flask import Blueprint, jsonify, request, g

from Config.common_config import LOGIN_TYPE, ACCOUNT_STATUS
from Libs.ErrorTips import TOKEN_NOT_VALID_ERROR, TOKEN_EXPIRE_ERROR, PHONE_NOT_NULL_ERROR, PHONE_NOT_VALID_ERROR, \
    PHONE_NOT_PERMISSION, USER_NOT_EXIST, LOGIN_ERROR, VERIFICATION_CODE_INVALID_ERROR, VERIFICATION_CODE_ERROR, \
    BASE_RESPONSE, ACCOUNT_ALREADY_EXISTS_ERROR, ACCOUNT_NOT_EXISTS_ERROR, ACCOUNT_AGENT_SPOT_NULL_ERROR, \
    ACCOUNT_ALREADY_DELETE_ERROR
from Libs.Helper import Helper
from Libs.Logger import logger
from Model.Agent.AgentAccountModel import AgentAccount
from Model.Agent.AgentLogRecordModel import AgentLogRecord
from Model.Agent.AgentSpotModel import AgentSpot
from Model.Base import db
from Service.AgentService import AgentService
from Service.SMSService import SMSService

route_account = Blueprint('account', __name__)


@route_account.route('/test')
def test():
    ip = request.remote_addr
    return jsonify({'code': 200, 'msg': 'success!', 'data': ip})


@route_account.route('/edit_account', methods=['GET', 'POST'])
def edit_user():
    json_data = request.get_json()
    old_phone = json_data['old_phone'] if 'old_phone' in json_data else ''
    new_phone = json_data['new_phone'] if 'new_phone' in json_data else ''
    user_name = json_data['name'] if 'name' in json_data else 'SSW'
    password = json_data['password'] if 'password' in json_data else ''
    comment = json_data['comment'] if 'comment' in json_data else ''
    spot_list = json_data['spot_list'] if 'spot_list' in json_data else []
    if not old_phone:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='old phone is null').to_dict())

    if not new_phone:
        return jsonify(PHONE_NOT_NULL_ERROR)

    result = Helper.checkPhone(new_phone)
    if not result:
        return jsonify(PHONE_NOT_VALID_ERROR)

    if not spot_list:
        return jsonify(ACCOUNT_AGENT_SPOT_NULL_ERROR)

    agent_info = AgentAccount.query.filter_by(phone=old_phone).first()
    if not agent_info:
        return jsonify(ACCOUNT_NOT_EXISTS_ERROR)

    agent_info.user_name = user_name
    agent_info.phone = new_phone
    agent_info.comment = comment

    if password:
        salt = AgentService.gene_salt()
        agent_info.salt_pwd = salt
        agent_info.password = AgentService.gene_pwd(password, salt)

    db.session.add(agent_info)

    agent_spot_info = AgentSpot.query.filter_by(agent_no=agent_info.id).all()
    for info in agent_spot_info:
        info.status = ACCOUNT_STATUS['delete']
        db.session.add(info)

    for i in spot_list:
        cur_spot_info = AgentSpot.query.filter_by(agent_no=agent_info.id, spot_no=i).first()
        if not cur_spot_info:
            cur_agent_spot = AgentSpot()
            cur_agent_spot.agent_no = agent_info.id
            cur_agent_spot.spot_no = i
            cur_agent_spot.status = ACCOUNT_STATUS['on_use']
            cur_agent_spot.created_at = datetime.datetime.now()
            cur_agent_spot.updated_at = datetime.datetime.now()
            db.session.add(cur_agent_spot)
        else:
            cur_spot_info.status = ACCOUNT_STATUS['on_use']
            db.session.add(cur_spot_info)

    db.session.commit()
    return jsonify(BASE_RESPONSE().to_dict())


@route_account.route('/add_account', methods=['GET', 'POST'])
def add_user():
    json_data = request.get_json()
    user_name = json_data['name'] if 'name' in json_data else 'SSW'
    phone = json_data['phone'] if 'phone' in json_data else None
    password = json_data['password'] if 'password' in json_data else None
    comment = json_data['comment'] if 'comment' in json_data else ''

    agent_no = AgentService.create_agent_no()
    if not phone:
        return jsonify(PHONE_NOT_NULL_ERROR)

    result = Helper.checkPhone(phone)
    if not result:
        return jsonify(PHONE_NOT_VALID_ERROR)

    agent_info = AgentAccount.query.filter_by(phone=phone, status=ACCOUNT_STATUS['on_use']).first()
    if agent_info:
        return jsonify(ACCOUNT_ALREADY_EXISTS_ERROR)

    user_info = AgentAccount()
    user_info.agent_no = agent_no
    user_info.user_name = user_name
    user_info.phone = phone
    user_info.level = 2
    user_info.status = ACCOUNT_STATUS['on_use']
    user_info.comment = comment
    user_info.created_at = datetime.datetime.now()
    user_info.updated_at = datetime.datetime.now()
    if password:
        salt = AgentService.gene_salt()
        user_info.salt_pwd = salt
        user_info.password = AgentService.gene_pwd(password, salt)
    db.session.add(user_info)

    spot_list = json_data['spot_list'] if 'spot_list' in json_data else []
    if not spot_list:
        return jsonify(ACCOUNT_AGENT_SPOT_NULL_ERROR)

    cur_info = AgentAccount.query.filter_by(phone=phone, status=ACCOUNT_STATUS['on_use']).first()
    if not cur_info:
        return jsonify(ACCOUNT_NOT_EXISTS_ERROR)

    for i in spot_list:
        user_spot = AgentSpot()
        user_spot.agent_no = cur_info.id
        user_spot.spot_no = i
        user_spot.status = ACCOUNT_STATUS['on_use']
        user_spot.created_at = datetime.datetime.now()
        user_spot.updated_at = datetime.datetime.now()
        db.session.add(user_spot)

    db.session.commit()
    return jsonify(BASE_RESPONSE().to_dict())


@route_account.route('/delete_account', methods=['GET', 'POST'])
def delete_user():
    json_data = request.get_json()
    phone = json_data['phone'] if 'phone' in json_data else ''
    if not phone:
        return jsonify(PHONE_NOT_NULL_ERROR)

    agent_info = AgentAccount.query.filter_by(phone=phone).first()
    if not agent_info:
        return jsonify(ACCOUNT_NOT_EXISTS_ERROR)

    agent_spot_info = AgentSpot.query.filter_by(agent_no=agent_info.id).all()
    for info in agent_spot_info:
        info.status = ACCOUNT_STATUS['delete']
        db.session.add(info)

    agent_info.status = ACCOUNT_STATUS['delete']
    db.session.add(agent_info)
    db.session.commit()

    return jsonify(BASE_RESPONSE().to_dict())


@route_account.route('/sendCode', methods=['GET', 'POST'])
def send_code():
    json_data = request.get_json()
    cur_ip = request.remote_addr
    phone = json_data['phone'] if 'phone' in json_data else None

    if not phone:
        return jsonify(PHONE_NOT_NULL_ERROR)

    logger.info(phone)
    # 判断该手机号是否再数据库中，不在返回无权限登录
    agent = AgentAccount.query.filter_by(phone=phone).first()
    logger.info('agent:')
    logger.info(agent)
    if not agent:
        return jsonify(PHONE_NOT_PERMISSION)

    # 判断该账号是否已被删除
    if agent.status == ACCOUNT_STATUS['delete']:
        return jsonify(ACCOUNT_ALREADY_DELETE_ERROR)

    result = Helper.checkPhone(phone)
    if not result:
        return jsonify(PHONE_NOT_VALID_ERROR)

    sms = SMSService()
    sms.phoneSendCode(phone, 92065, '灰兔智能')

    agent_log = AgentLogRecord()
    agent_log.phone = phone
    agent_log.ip = cur_ip
    agent_log.last_login = datetime.datetime.now()
    agent_log.login_type = LOGIN_TYPE['send_code']
    agent_log.created_at = datetime.datetime.now()
    agent_log.updated_at = datetime.datetime.now()
    db.session.add(agent_log)
    db.session.commit()

    return jsonify(BASE_RESPONSE().to_dict())


# @route_account.route('/login', methods=['GET', 'POST'])
def login():
    token = request.headers.get('token')
    cur_ip = request.remote_addr
    json_data = request.get_json()

    data = {}
    phone = json_data['phone'] if 'phone' in json_data else None
    code = json_data['code'] if 'code' in json_data else None

    # test
    if phone == '18896812809' and code == '1234':
        test_agent_info = AgentAccount.query.filter_by(id=1).first()
        g.user = test_agent_info
        data['token'] = test_agent_info.access_token
        data['user_name'] = test_agent_info.user_name
        data['phone'] = test_agent_info.phone
        data['level'] = test_agent_info.level
        data['spot_info'] = AgentService.get_spot_info(test_agent_info)
        return jsonify(BASE_RESPONSE(data=data).to_dict())

    if token:
        # token登录
        user_info = AgentService.check_agent_token(token)
        if user_info == 1:
            return jsonify(TOKEN_NOT_VALID_ERROR)
        if user_info == 2:
            return jsonify(TOKEN_EXPIRE_ERROR)

        # 判断该账号是否已被删除
        if user_info.status == ACCOUNT_STATUS['delete']:
            return jsonify(ACCOUNT_ALREADY_DELETE_ERROR)

        salt = AgentService.gene_salt()
        new_token = "%s#%s" % (AgentService.gene_agent_code(user_info, salt), user_info.id)
        user_info.access_token = new_token
        user_info.salt = salt
        user_info.last_login = datetime.datetime.now()
        user_info.expire_time = datetime.datetime.now() + datetime.timedelta(days=7)
        user_info.updated_at = datetime.datetime.now()
        db.session.add(user_info)

        agent_log = AgentLogRecord()
        agent_log.phone = user_info.phone
        agent_log.ip = cur_ip
        agent_log.last_login = user_info.last_login
        agent_log.login_type = LOGIN_TYPE['token_login']
        agent_log.created_at = datetime.datetime.now()
        agent_log.updated_at = datetime.datetime.now()
        db.session.add(agent_log)
        db.session.commit()

        data['token'] = new_token
        data['user_name'] = user_info.user_name
        data['phone'] = user_info.phone
        data['level'] = user_info.level
        data['spot_info'] = AgentService.get_spot_info(user_info)
        return jsonify(BASE_RESPONSE(data=data).to_dict())
    elif phone and code:
        # 验证码登录
        # 判断验证码是否正确
        sms = SMSService()
        res = sms.verificate(phone, code)
        if res == -1:
            return jsonify(VERIFICATION_CODE_INVALID_ERROR)
        elif res == -2:
            return jsonify(VERIFICATION_CODE_ERROR)

        agent_info = AgentAccount.query.filter_by(phone=phone, status=ACCOUNT_STATUS['on_use']).first()
        if not agent_info:
            return jsonify(USER_NOT_EXIST)

        salt = AgentService.gene_salt()
        new_token = "%s#%s" % (AgentService.gene_agent_code(agent_info, salt), agent_info.id)
        agent_token = new_token
        agent_info.access_token = agent_token
        agent_info.salt = salt
        agent_info.last_login = datetime.datetime.now()
        agent_info.expire_time = datetime.datetime.now() + datetime.timedelta(days=7)
        agent_info.updated_at = datetime.datetime.now()
        db.session.add(agent_info)

        agent_log = AgentLogRecord()
        agent_log.phone = agent_info.phone
        agent_log.ip = cur_ip
        agent_log.last_login = agent_info.last_login
        agent_log.login_type = LOGIN_TYPE['code_login']
        agent_log.created_at = datetime.datetime.now()
        agent_log.updated_at = datetime.datetime.now()
        db.session.add(agent_log)
        db.session.commit()

        data['token'] = new_token
        data['user_name'] = agent_info.user_name
        data['phone'] = agent_info.phone
        data['level'] = agent_info.level
        data['spot_info'] = AgentService.get_spot_info(agent_info)

        return jsonify(BASE_RESPONSE(data=data).to_dict())
    else:
        return jsonify(LOGIN_ERROR)


@route_account.route('/login', methods=['GET', 'POST'])
def login():
    token = request.headers.get('token')
    cur_ip = request.remote_addr
    json_data = request.get_json()

    data = {}
    phone = json_data['phone'] if 'phone' in json_data else None
    code = json_data['code'] if 'code' in json_data else None
    login_type = json_data['type'] if 'type' in json_data else 1  # 1.验证码登录，2.密码登录

    # test
    if phone == '18896812809' and code == '1234':
        test_agent_info = AgentAccount.query.filter_by(id=1).first()
        g.user = test_agent_info
        data['token'] = test_agent_info.access_token
        data['user_name'] = test_agent_info.user_name
        data['phone'] = test_agent_info.phone
        data['level'] = test_agent_info.level
        data['spot_info'] = AgentService.get_spot_info(test_agent_info)
        return jsonify(BASE_RESPONSE(data=data).to_dict())

    if token:
        # token登录
        user_info = AgentService.check_agent_token(token)
        if user_info == 1:
            return jsonify(TOKEN_NOT_VALID_ERROR)
        if user_info == 2:
            return jsonify(TOKEN_EXPIRE_ERROR)

        # 判断该账号是否已被删除
        if user_info.status == ACCOUNT_STATUS['delete']:
            return jsonify(ACCOUNT_ALREADY_DELETE_ERROR)

        salt = AgentService.gene_salt()
        new_token = "%s#%s" % (AgentService.gene_agent_code(user_info, salt), user_info.id)
        user_info.access_token = new_token
        user_info.salt = salt
        user_info.last_login = datetime.datetime.now()
        user_info.expire_time = datetime.datetime.now() + datetime.timedelta(days=7)
        user_info.updated_at = datetime.datetime.now()
        db.session.add(user_info)

        agent_log = AgentLogRecord()
        agent_log.phone = user_info.phone
        agent_log.ip = cur_ip
        agent_log.last_login = user_info.last_login
        agent_log.login_type = LOGIN_TYPE['token_login']
        agent_log.created_at = datetime.datetime.now()
        agent_log.updated_at = datetime.datetime.now()
        db.session.add(agent_log)
        db.session.commit()

        data['token'] = new_token
        data['user_name'] = user_info.user_name
        data['phone'] = user_info.phone
        data['level'] = user_info.level
        data['spot_info'] = AgentService.get_spot_info(user_info)
        return jsonify(BASE_RESPONSE(data=data).to_dict())
    else:
        if login_type == 1:
            # 验证码登录
            # 判断验证码是否正确
            sms = SMSService()
            res = sms.verificate(phone, code)
            if res == -1:
                return jsonify(VERIFICATION_CODE_INVALID_ERROR)
            elif res == -2:
                return jsonify(VERIFICATION_CODE_ERROR)

            agent_info = AgentAccount.query.filter_by(phone=phone, status=ACCOUNT_STATUS['on_use']).first()
            if not agent_info:
                return jsonify(USER_NOT_EXIST)

            salt = AgentService.gene_salt()
            new_token = "%s#%s" % (AgentService.gene_agent_code(agent_info, salt), agent_info.id)
            agent_token = new_token
            agent_info.access_token = agent_token
            agent_info.salt = salt
            agent_info.last_login = datetime.datetime.now()
            agent_info.expire_time = datetime.datetime.now() + datetime.timedelta(days=7)
            agent_info.updated_at = datetime.datetime.now()
            db.session.add(agent_info)

            agent_log = AgentLogRecord()
            agent_log.phone = agent_info.phone
            agent_log.ip = cur_ip
            agent_log.last_login = agent_info.last_login
            agent_log.login_type = LOGIN_TYPE['code_login']
            agent_log.created_at = datetime.datetime.now()
            agent_log.updated_at = datetime.datetime.now()
            db.session.add(agent_log)
            db.session.commit()

            data['token'] = new_token
            data['user_name'] = agent_info.user_name
            data['phone'] = agent_info.phone
            data['level'] = agent_info.level
            data['spot_info'] = AgentService.get_spot_info(agent_info)

            return jsonify(BASE_RESPONSE(data=data).to_dict())
        else:
            # 密码登录
            # 判断密码是否正确
            agent_info = AgentAccount.query.filter_by(phone=phone, status=ACCOUNT_STATUS['on_use']).first()
            if not agent_info:
                return jsonify(USER_NOT_EXIST)

            if not agent_info.password:
                return jsonify(BASE_RESPONSE(error_code=-1, error_message='login error').to_dict())

            if agent_info.password != AgentService.gene_pwd(code, agent_info.salt_pwd):
                return jsonify(BASE_RESPONSE(error_code=-1, error_message='手机号或密码错误').to_dict())

            salt = AgentService.gene_salt()
            new_token = "%s#%s" % (AgentService.gene_agent_code(agent_info, salt), agent_info.id)
            agent_token = new_token
            agent_info.access_token = agent_token
            agent_info.salt = salt
            agent_info.last_login = datetime.datetime.now()
            agent_info.expire_time = datetime.datetime.now() + datetime.timedelta(days=7)
            agent_info.updated_at = datetime.datetime.now()
            db.session.add(agent_info)

            agent_log = AgentLogRecord()
            agent_log.phone = agent_info.phone
            agent_log.ip = cur_ip
            agent_log.last_login = agent_info.last_login
            agent_log.login_type = LOGIN_TYPE['password']
            agent_log.created_at = datetime.datetime.now()
            agent_log.updated_at = datetime.datetime.now()
            db.session.add(agent_log)
            db.session.commit()

            data['token'] = new_token
            data['user_name'] = agent_info.user_name
            data['phone'] = agent_info.phone
            data['level'] = agent_info.level
            data['spot_info'] = AgentService.get_spot_info(agent_info)

            return jsonify(BASE_RESPONSE(data=data).to_dict())
