# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, FetchedValue, String, DateTime

from Model.Base import BaseModel


class AgentLogRecord(BaseModel):
    __tablename__ = 'agent_log_record'

    id = Column(Integer, primary_key=True)
    phone = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False, server_default=FetchedValue())
    ip = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False, server_default=FetchedValue())
    last_login = Column(DateTime, nullable=False, server_default=FetchedValue())
    login_type = Column(Integer, nullable=False, server_default=FetchedValue(), comment='1:验证码登录 2：token 3:发送验证码')
