# -*- coding: utf-8 -*-
import datetime
import time

from flask import Blueprint, jsonify, request, g

from Libs.ErrorTips import MACHINE_NOT_EXIST_ERROR, MACHINE_HATCH_NOT_ILLEGAL, MACHINE_NOT_ONLINE, BASE_RESPONSE
from Libs.Helper.Helper import getTodayDate
from Libs.Onenet.Message.Message import CommandMessage
from Libs.Onenet.OneNetApi import OneNetApi
from Model.Base import db
from Model.Machine.MachineModel import Machine
from Model.Machine.TakeoutToolModel import TakeoutTool
from Model.Power.PowerModel import Power
from Model.Spot.SpotModel import Spot
from Redis_Cache import redis
from Service.SMSService import SMSService
from Service.ToolService import ToolService
from Config.common_config import NEW_ONENET_CONFIG as new_onenet_config, ONENET_CONFIG as onenet_config, \
    TAKEOUT_RECORD_MAC_NO, TAKEOUT_TOOL_TIPS_PHONE

route_tool = Blueprint('tool', __name__)


@route_tool.route('/power_info', methods=['GET', 'POST'])
def get_power_info():
    json_data = request.get_json()
    mac_no = json_data['mac_no'] if 'mac_no' in json_data else None
    if not mac_no:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='illegal mac no').to_dict())

    machine_info = Machine.query.filter_by(mac_no=mac_no).first()
    if not machine_info:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    data = ToolService.get_power_info_by_machine(machine_info.id)
    return jsonify(BASE_RESPONSE(data=data).to_dict())


@route_tool.route('/takeout', methods=['GET', 'POST'])
def take_out():
    json_data = request.get_json()
    mac_no = json_data['mac_no'] if 'mac_no' in json_data else None
    hatch_no = json_data['hatch_no'] if 'hatch_no' in json_data else None

    if not mac_no or not hatch_no:
        return jsonify(MACHINE_HATCH_NOT_ILLEGAL)

    if hatch_no > 60 or hatch_no < 1:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='mac_no or hatch_no error').to_dict())

    machine_info = Machine.query.filter_by(mac_no=mac_no).first()

    if not machine_info:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    if machine_info.life != 1:
        return jsonify(MACHINE_NOT_ONLINE)

    command_message = CommandMessage(machine_info.he_cloud_device_id, chr(0x46), str(hatch_no - 1))
    if machine_info.he_cloud_device_id in new_onenet_config["he_cloud_device_id"]:
        one_api = OneNetApi(new_onenet_config["api_key"], new_onenet_config["url"])
    else:
        one_api = OneNetApi(onenet_config["api_key"], onenet_config["url"])
    result = one_api.send_data_to_edp(command_message.get_device_id(), 1, 0, command_message.pack())
    if "errno" in result.keys() and result['errno'] == 0:
        if result['error'] == 'succ':
            return jsonify(BASE_RESPONSE().to_dict())
    else:
        if "error_message" in result.keys():
            return jsonify(BASE_RESPONSE(error_message=result['error_message']).to_dict())
        else:
            return jsonify(BASE_RESPONSE(error_code=-1, error_message='Fail').to_dict())


@route_tool.route('/takeout_multiple', methods=['GET', 'POST'])
def take_out_multiple():
    json_data = request.get_json()
    mac_no = json_data['mac_no'] if 'mac_no' in json_data else None
    hatch_no_list = json_data['hatch_no'] if 'hatch_no' in json_data else []

    if not mac_no or not hatch_no_list:
        return jsonify(MACHINE_HATCH_NOT_ILLEGAL)

    machine_info = Machine.query.filter_by(mac_no=mac_no).first()
    if not machine_info:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    if machine_info.life != 1:
        return jsonify(MACHINE_NOT_ONLINE)

    take_out_success_number = 0

    data = {}
    for i in hatch_no_list:
        command_message = CommandMessage(machine_info.he_cloud_device_id, chr(0x46), str(i - 1))
        if machine_info.he_cloud_device_id in new_onenet_config["he_cloud_device_id"]:
            one_api = OneNetApi(new_onenet_config["api_key"], new_onenet_config["url"])
        else:
            one_api = OneNetApi(onenet_config["api_key"], onenet_config["url"])
        result = one_api.send_data_to_edp(command_message.get_device_id(), 1, 0, command_message.pack())
        takeout_tool = TakeoutTool()
        takeout_tool.customer_id = g.user.id
        takeout_tool.mac_no = mac_no
        takeout_tool.spot_id = machine_info.spot_id
        takeout_tool.hatch_no = i
        if 'errno' in result.keys() and result['errno'] == 0:
            if result['error'] == 'succ':
                data[i] = 'success'
                Power.query.filter_by(hatch_no=i, machine_id=machine_info.id).update({'status': 8, 'has_power': 0})
                db.session.commit()
                take_out_success_number += 1
                takeout_tool.status = 1
            else:
                data[i] = 'fail'
                takeout_tool.status = 0
        else:
            if 'error_message' in result.keys():
                data[i] = result['error_message']
            else:
                data[i] = 'fail'
            takeout_tool.status = 0
        db.session.add(takeout_tool)
        db.session.commit()
        time.sleep(3)

    # 当弹出充电宝数量大于5台时，给管理员手机发送短信
    zero_today, last_today = getTodayDate()
    cur_user_phone = g.user.phone
    if cur_user_phone in TAKEOUT_TOOL_TIPS_PHONE:
        cur_take_out_num = db.session.query(TakeoutTool).filter(TakeoutTool.customer_id == g.user.id,
                                                                TakeoutTool.created_at >= zero_today,
                                                                TakeoutTool.created_at <= last_today).count()
        # cur_take_out_num = len(hatch_no_list)

        if cur_take_out_num >= 5:
            cur_user_name = g.user.user_name
            cur_spot_name = Spot.query.filter_by(id=machine_info.spot_id).first().spotname

            # 发短信
            sms = SMSService()
            sms.phoneSendTips(cur_user_name, cur_spot_name, mac_no, cur_take_out_num, cur_user_phone, '18068402080', '灰兔智能')

    try:
        if take_out_success_number > 0 and machine_info.mac_no in TAKEOUT_RECORD_MAC_NO:
            redis_result = redis.get('M_TKO_C_{}'.format(machine_info.mac_no))
            if redis_result:
                take_out_date, take_out_number = str(redis_result, encoding='utf-8').split('_')
                take_out_number = int(take_out_number)
                today_date = datetime.datetime.now().strftime('%Y-%m-%d')
                if take_out_date == today_date:
                    take_out_date = today_date
                    take_out_number += take_out_success_number
                else:
                    take_out_date = datetime.datetime.now().strftime('%Y-%m-%d')
                    take_out_number = take_out_success_number
            else:
                take_out_date = datetime.datetime.now().strftime('%Y-%m-%d')
                take_out_number = take_out_success_number
            redis_data = "{}_{}".format(take_out_date, take_out_number)
            redis.set('M_TKO_C_{}'.format(machine_info.mac_no), redis_data)
    except Exception as e:
        pass

    return jsonify(BASE_RESPONSE(data=data).to_dict())


@route_tool.route('/reset')
def tool_reset():
    mac_no = request.args.get('mac_no', '')

    if not mac_no:
        return jsonify({'code': -1, 'msg': 'mac no null'})

    machine_info = Machine.query.filter_by(mac_no=mac_no).first()
    if not machine_info:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    power_info = Power.query.filter_by(machine_id=machine_info.id, status=7).all()

    for power in power_info:
        power.status = 2

    db.session.commit()

    return jsonify(BASE_RESPONSE().to_dict())
