# -*- coding: utf-8 -*-
from Model.Power.PowerModel import Power


class ToolService():
    @staticmethod
    def get_power_info_by_machine(machine_id):
        power_data = []
        power_infos = Power.query.filter_by(machine_id=machine_id).order_by(Power.hatch_no.asc()).all()
        if not power_infos:
            for i in range(55):
                cur_power = {}
                cur_power['hatch_no'] = i+1
                cur_power['power'] = 0
                cur_power['status'] = 0
                power_data.append(cur_power)
        else:
            for power_info in power_infos:
                cur_power = {}
                cur_power['hatch_no'] = power_info.hatch_no
                cur_power['power'] = power_info.has_power
                if power_info.status == 7:
                    cur_power['status'] = 7
                else:
                    cur_power['status'] = 1
                power_data.append(cur_power)
        return power_data
