# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, String, FetchedValue

from Model.Base import BaseModel


class Invoice(BaseModel):
    __tablename__ = 'invoice'

    id = Column(Integer, primary_key=True)
    fpqqlsh = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False, comment='发票请求流水号')
    fp_dm = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False, comment='发票代码')
    fp_hm = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False, comment='发票号码')
    kprq = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False, comment='开票日期')
    jym = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False, comment='校验码')
    pdf_url = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False, comment='PDF下载地址')
    sp_url = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False, comment='售票地址')
    is_red = Column(Integer, nullable=False, server_default=FetchedValue(), comment='0:未红冲 1:已红冲 2:红冲发票')
    status = Column(Integer, nullable=False, server_default=FetchedValue(), comment='1:正常  2:删除')
