# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, String, FetchedValue, Text

from Model.Base import BaseModel


class RentRefund(BaseModel):
    __tablename__ = 'rent_refund'

    id = Column(Integer, primary_key=True)
    refund_no = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False)
    production_id = Column(Integer, server_default=FetchedValue(), nullable=False)
    fee = Column(Integer, server_default=FetchedValue(), nullable=False)
    comment = Column(Text(collation='utf8mb4_unicode_ci'))
    cause = Column(String(191, 'utf8mb4_unicode_ci'))
