# -*- coding: utf-8 -*-
from flask import Response
from flask.json import dumps


class BASE_RESPONSE(object):
    def __init__(self, error_code=200, error_message='Success', data=None):
        self.error_code = error_code
        self.error_message = error_message
        self.data = data

    def to_dict(self):
        return {'error_code': self.error_code, 'error_message': self.error_message, 'data': self.data}


class BASE_SUCCESS_RESPONSE(Response):
    def __init__(self, data=None, error_code=200, error_message='Success'):
        result = dumps(dict(data=data, error_code=error_code, error_message=error_message))
        Response.__init__(self, result, mimetype='application/json')


TOKEN_NOT_VALID_ERROR = {
    "error_code": 1001,
    "error_message": "无效的token"
}

TOKEN_NOT_PROVIDER_ERROR = {
    "error_code": 1002,
    "error_message": "token未提供"
}

TOKEN_EXPIRE_ERROR = {
    "error_code": 1003,
    "error_message": "token超时"
}

PHONE_NOT_NULL_ERROR = {
    "error_code": 1004,
    "error_message": "手机号为空"
}

PHONE_NOT_VALID_ERROR = {
    "error_code": 1005,
    "error_message": "无效的手机号"
}

PHONE_NOT_PERMISSION = {
    "error_code": 1006,
    "error_message": "无权登录"
}

LOGIN_ERROR = {
    "error_code": 1007,
    "error_message": "验证码为空"
}

VERIFICATION_CODE_INVALID_ERROR = {
    "error_code": 1008,
    "error_message": "验证码已失效"
}

VERIFICATION_CODE_ERROR = {
    "error_code": 1009,
    "error_message": "验证码错误"
}

USER_NOT_EXIST = {
    "error_code": 1010,
    "error_message": "用户不存在"
}

PARAMETER_ERROR = {
    "error_code": 1011,
    "error_message": "参数有误"
}

MACHINE_HATCH_NOT_ILLEGAL = {
    "error_code": 1101,
    "error_message": "机柜或仓口号错误"
}

MACHINE_NOT_EXIST_ERROR = {
    "error_code": 1102,
    "error_message": "机柜不存在"
}

MACHINE_NOT_ONLINE = {
    "error_code": 1103,
    "error_message": "机柜不在线"
}

ACCOUNT_ALREADY_EXISTS_ERROR = {
    "error_code": 1201,
    "error_message": "该账号已存在"
}

ACCOUNT_NOT_EXISTS_ERROR = {
    "error_code": 1202,
    "error_message": "账号不存在"
}

ACCOUNT_ALREADY_DELETE_ERROR = {
    "error_code": 1203,
    "error_message": "账号已被删除"
}

ACCOUNT_AGENT_SPOT_NULL_ERROR = {
    "error_code": 1204,
    "error_message": "代理商景点列表为空"
}

REFUND_NOT_RENT_INFO = {
    "error_code": 1301,
    "error_message": "没有该订单信息"
}

REFUND_BACK_TIME_ERROR = {
    "error_code": 1302,
    "error_message": "归还时间异常"
}

REFUND_NOT_PRODUCTION_INFO = {
    "error_code": 1303,
    "error_message": "没有该讲解器信息"
}

REFUND_MONEY_IS_ZERO = {
    "error_code": 1304,
    "error_message": "退款金额为零"
}

OPERATE_TYPE_ERROR = {
    "error_code": 1401,
    "error_message": "type错误"
}

OPERATE_LEVEL_ERROR = {
    "error_code": 1402,
    "error_message": "权限错误"
}

OPERATE_ERROR = {
    "error_code": 1403,
    "error_message": "操作有误"
}

AGNET_MODULES_ERROR = {
    "error_code": 1404,
    "error_message": "用户未绑定模块"
}

ACTION_CODE_ERROR = {
    "error_code": 1501,
    "error_message": "退款操作码错误"
}
