# -*- coding: utf-8 -*-
import datetime

from flask import Blueprint, jsonify, request, g

from Libs.ErrorTips import BASE_RESPONSE
from Libs.Helper import Helper
from Model.Customer.CustomerModel import Customer
from Service.ReportService import ReportService

route_report = Blueprint('report', __name__)


@route_report.route('/chart', methods=['GET', 'POST'])
def user_chart():
    json_data = request.get_json()
    spot_id = json_data['spot_id'] if 'spot_id' in json_data else 0
    type = json_data['type'] if 'type' in json_data else 1
    if type not in [1, 2, 3]:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='type error').to_dict())

    yesterday = datetime.datetime.now() - datetime.timedelta(days=1)
    zero_yesterday = yesterday - datetime.timedelta(hours=yesterday.hour, minutes=yesterday.minute,
                                                    seconds=yesterday.second,
                                                    microseconds=yesterday.microsecond)
    last_yesterday = zero_yesterday + datetime.timedelta(hours=23, minutes=59, seconds=59)
    cur_user = g.user
    if cur_user.level == 1:
        if type == 2:
            seven_start = zero_yesterday - datetime.timedelta(days=6)
            data = ReportService.get_history_rent_number_admin(spot_id, seven_start, last_yesterday)
        elif type == 3:
            thirty_start_date = zero_yesterday - datetime.timedelta(days=29)
            data = ReportService.get_history_rent_number_admin(spot_id, thirty_start_date, last_yesterday)
        else:
            data = ReportService.get_today_rent_number_admin(spot_id)
        return jsonify(BASE_RESPONSE(data=data).to_dict())
    elif cur_user.level == 2 or cur_user.level == 4 or cur_user.level == 5:
        if type == 2:
            seven_start = zero_yesterday - datetime.timedelta(days=6)
            data = ReportService.get_history_rent_number_agent(spot_id, seven_start, last_yesterday)
        elif type == 3:
            thirty_start_date = zero_yesterday - datetime.timedelta(days=29)
            data = ReportService.get_history_rent_number_agent(spot_id, thirty_start_date, last_yesterday)
        else:
            data = ReportService.get_today_rent_number_agent(spot_id)
        return jsonify(BASE_RESPONSE(data=data).to_dict())
    else:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='Failed').to_dict())


@route_report.route('/gender')
def user_gender():
    male = 0
    female = 0
    unknown = 0
    gender_info = Customer.query.with_entities(Customer.gender).all()
    for info in gender_info:
        if info.gender == 1:
            male += 1
        elif info.gender == 2:
            female += 1
        else:
            unknown += 1
    return jsonify({'code': 200, 'msg': 'success', 'data': {'male': male, 'female': female, 'unknown': unknown}})


@route_report.route('/rent_number', methods=['GET', 'POST'])
def user_rent_number():
    json_data = request.get_json()
    spot_id = json_data['spot_id'] if 'spot_id' in json_data else 0

    number_info = ReportService.get_customer_rent_number(spot_id)
    return jsonify(BASE_RESPONSE(data=number_info).to_dict())


@route_report.route('/rent_time', methods=['GET', 'POST'])
def user_rent_time():
    json_data = request.get_json()
    spot_id = json_data['spot_id'] if 'spot_id' in json_data else 0

    rent_time_info = ReportService.get_customer_rent_time(spot_id)
    return jsonify(BASE_RESPONSE(data=rent_time_info).to_dict())


@route_report.route('/income_chart', methods=['GET', 'POST'])
def user_income_chart():
    json_data = request.get_json()
    spot_id = json_data['spot_id'] if 'spot_id' in json_data else 0
    data_type = json_data['type'] if 'type' in json_data else 1  # 1:七天，2:一个月，3:六个月
    if int(data_type) not in [1, 2, 3]:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='type error').to_dict())

    if int(data_type) == 2:
        start_time, end_time = Helper.get_recent_someday_date(29)
        data = ReportService.get_spot_day_income(spot_id, start_time, end_time, 30)
        return jsonify(BASE_RESPONSE(data=data).to_dict())
    elif int(data_type) == 3:
        start_time, end_time = Helper.get_recent_six_month()
        data = ReportService.get_spot_month_income(spot_id, start_time, end_time)
        return jsonify(BASE_RESPONSE(data=data).to_dict())
    else:
        start_time, end_time = Helper.get_recent_someday_date(6)
        data = ReportService.get_spot_day_income(spot_id, start_time, end_time, 7)
        return jsonify(BASE_RESPONSE(data=data).to_dict())


@route_report.route('/over_record', methods=['GET', 'POST'])
def rent_over_record():
    json_data = request.get_json()
    spot_id = json_data['spot_id'] if 'spot_id' in json_data else 0
    data_type = json_data['type'] if 'type' in json_data else 1  # 1:日,2:月
    date = json_data['date'] if 'date' in json_data else ''
    page = json_data['page'] if 'page' in json_data else 0
    limit = json_data['limit'] if 'limit' in json_data else 10

    if int(data_type) not in [1, 2]:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='type error').to_dict())

    total, total_rent, data = ReportService.get_spot_rent_record(spot_id, int(data_type), date, page, limit)
    return jsonify(
        {'error_code': 200, 'error_message': 'Success', 'total': total, 'total_rent': total_rent, 'data': data})
