# -*- coding: utf-8 -*-
__author__ = 'weiqiang'
__date__ = '2020/9/10 11:07'

from sqlalchemy import Column, Integer, FetchedValue, String
from Model.Base import BaseModel


class TakeoutTool(BaseModel):
    __tablename__ = 'takeout_tool'

    id = Column(Integer, primary_key=True)
    customer_id = Column(Integer, nullable=False, comment='用户id')
    mac_no = Column(String(16, 'utf8mb4_unicode_ci'), nullable=False, comment='机柜编号')
    spot_id = Column(Integer, nullable=False, comment='景点id')
    hatch_no = Column(Integer, nullable=False, comment='弹出的仓口号')
    status = Column(Integer, nullable=False, server_default=FetchedValue(), comment='状态：0弹出失败，1弹出成功')
