# -*- coding: utf-8 -*-
import random
import string

from qcloudsms_py import SmsSingleSender, SmsMultiSender
from qcloudsms_py.httpclient import HTTPError
from Config.common_config import SMS_CONFIG
from Libs.Logger import logger
from Redis_Cache import redis


class SMSService():
    def __init__(self):
        self.appid = SMS_CONFIG['app_id']
        self.appKey = SMS_CONFIG['app_key']
        try:
            self.ssender = SmsSingleSender(self.appid, self.appKey)
            self.msender = SmsMultiSender(self.appid, self.appKey)
        except Exception as e:
            print(e)

    def create_code(self, length=4):
        '''
        生成验证码
        :param length:
        :return:
        '''
        verification = []
        letters = string.digits
        for i in range(length):
            letter = letters[random.randint(0, 9)]
            verification.append(letter)
        return "".join(verification)

    def make_code(self, phoneNumber):
        '''
        设置验证码300秒有效
        :param phoneNumber:
        :return:
        '''
        code = self.create_code(4)
        redis.set('V_C' + str(phoneNumber), code, 300)
        logger.info("code: " + code)
        return code

    def phoneSendCode(self, phoneNumber, tempId, sign='灰兔智能'):
        '''
        发送验证码
        :param phoneNumber:
        :param tempId:
        :param sign:
        :return:
        '''
        code = self.make_code(phoneNumber)
        params = [code]
        try:
            result = self.ssender.send_with_param(86, phoneNumber, tempId, params, sign=sign, extend="", ext='')
            return result
        except HTTPError as e:
            print(e)
        except Exception as e:
            print(e)
        return

    def phoneSendCodeWithContent(self, phoneNumber, tempId, Content, sign='灰兔智能'):
        '''
        发送验证码
        :param phoneNumber:
        :param tempId:
        :param sign:
        :return:
        '''
        try:
            if isinstance(phoneNumber, list):
                result = self.msender.send_with_param(86, phoneNumber, tempId, Content, sign=sign, extend="", ext='')
            else:
                result = self.ssender.send_with_param(86, phoneNumber, tempId, Content, sign=sign, extend="", ext='')
            return result
        except HTTPError as e:
            print(e)
        except Exception as e:
            print(e)
        return

    def verificate(self, phoneNumber, code):
        '''
        判断验证码，-1验证码过期 -2验证码错误 0匹配
        :param phoneNumber:
        :param code:
        :return:
        '''
        logger.info("phone:" + phoneNumber + ", code:" + code)
        ver = redis.get('V_C' + str(phoneNumber))
        logger.info(ver)
        if ver is None:
            return -1
        else:
            if ver == str(code).encode('utf-8'):
                return 0
            else:
                return -2
