# -*- coding: utf-8 -*-
import calendar
import datetime
import re
import time


def getFormatDate(date=None, format="%Y-%m-%d %H:%M:%S"):
    '''
    获取格式化时间
    :param date: 时间
    :param format: 格式
    :return:
    '''
    if date is None:
        date = datetime.datetime.now()
    return date.strftime(format)


def getTodayDate():
    '''
    获取今天零点和24点
    :return:
    '''
    now = datetime.datetime.now()
    zero_today = now - datetime.timedelta(hours=now.hour, minutes=now.minute, seconds=now.second,
                                          microseconds=now.microsecond)
    last_today = zero_today + datetime.timedelta(hours=23, minutes=59, seconds=59)

    return getFormatDate(zero_today), getFormatDate(last_today)


def getSevenDate():
    '''
    获取近七天零点和24点
    :return:
    '''
    now = datetime.datetime.now()
    zero_today = now - datetime.timedelta(hours=now.hour, minutes=now.minute, seconds=now.second,
                                          microseconds=now.microsecond)
    last_today = zero_today + datetime.timedelta(hours=23, minutes=59, seconds=59)
    seven_start = zero_today - datetime.timedelta(days=6)
    return getFormatDate(seven_start), getFormatDate(last_today)


def get_recent_someday_date(days):
    now = datetime.datetime.now() - datetime.timedelta(days=1)
    zero_today = now - datetime.timedelta(hours=now.hour, minutes=now.minute, seconds=now.second,
                                          microseconds=now.microsecond)
    last_today = zero_today + datetime.timedelta(hours=23, minutes=59, seconds=59)
    seven_start = zero_today - datetime.timedelta(days=days)
    return seven_start.strftime('%Y-%m-%d'), last_today.strftime('%Y-%m-%d')


def get_recent_six_month():
    now = datetime.datetime.now()
    first = now.replace(day=1)
    last_month = first - datetime.timedelta(days=1)
    second = last_month.replace(day=1)
    last_second_month = second - datetime.timedelta(days=1)
    third = last_second_month.replace(day=1)
    last_third_month = third - datetime.timedelta(days=1)
    four = last_third_month.replace(day=1)
    last_four_month = four - datetime.timedelta(days=1)
    five = last_four_month.replace(day=1)
    last_five_month = five - datetime.timedelta(days=1)
    six = last_five_month.replace(day=1)
    last_six_month = six - datetime.timedelta(days=1)
    return last_six_month.strftime('%Y%m'), last_month.strftime('%Y%m')


def getYesterdayDate():
    '''
    获取昨天零点和24点
    :return:
    '''
    now = datetime.datetime.now() - datetime.timedelta(days=1)
    zero_today = now - datetime.timedelta(hours=now.hour, minutes=now.minute, seconds=now.second,
                                          microseconds=now.microsecond)
    last_today = zero_today + datetime.timedelta(hours=23, minutes=59, seconds=59)

    return getFormatDate(zero_today), getFormatDate(last_today)


def getWeekDate():
    '''
    获取本周一和周日
    :return:
    '''
    now = datetime.datetime.now()
    zero_week = now - datetime.timedelta(days=now.weekday(), hours=now.hour, minutes=now.minute, seconds=now.second,
                                         microseconds=now.microsecond)
    last_week = now + datetime.timedelta(days=6 - now.weekday(), hours=23 - now.hour, minutes=59 - now.minute,
                                         seconds=59 - now.second)

    return getFormatDate(zero_week), getFormatDate(last_week)


def getLastWeekDate():
    '''
    获取上周一和周日
    :return:
    '''
    now = datetime.datetime.now()
    zero_last_week = now - datetime.timedelta(days=now.weekday() + 7, hours=now.hour, minutes=now.minute,
                                              seconds=now.second, microseconds=now.microsecond)
    last_last_week = now - datetime.timedelta(days=now.weekday() + 1) \
                     + datetime.timedelta(hours=23 - now.hour, minutes=59 - now.minute, seconds=59 - now.second)

    return getFormatDate(zero_last_week), getFormatDate(last_last_week)


def getMonthDate():
    '''
    获取本月第一天和最后一天
    :return:
    '''
    now = datetime.datetime.now()
    zero_month = datetime.datetime(now.year, now.month, 1)
    cur_month = now.month
    cur_year = now.year
    if now.month == 12:
        cur_month = 0
        cur_year += 1
    last_month = datetime.datetime(cur_year, cur_month + 1, 1) - datetime.timedelta(days=1) + datetime.timedelta(
        hours=23, minutes=59, seconds=59)
    return getFormatDate(zero_month), getFormatDate(last_month)


def getLastMonthDate():
    '''
    获取上月第一天和最后一天
    :return:
    '''
    now = datetime.datetime.now()
    last_last_month = datetime.datetime(now.year, now.month, 1) - datetime.timedelta(days=1) + datetime.timedelta(
        hours=23, minutes=59, seconds=59)
    zero_last_month = datetime.datetime(last_last_month.year, last_last_month.month, 1)
    return getFormatDate(zero_last_month), getFormatDate(last_last_month)


def checkPhone(phone):
    phone_pat = re.compile('^(13\d|14[5|7]|15\d|166|17[3|6|7]|18\d|19\d)\d{8}$')
    res = re.search(phone_pat, phone)
    return res


def checkTime(start_time, end_time):
    if start_time is None or end_time is None:
        return 0

    start_time_array = time.strptime(str(start_time), "%Y-%m-%d %H:%M:%S")
    end_time_array = time.strptime(str(end_time), "%Y-%m-%d %H:%M:%S")

    start_time_stamp = time.mktime(start_time_array)
    end_time_stamp = time.mktime(end_time_array)

    use_time = end_time_stamp - start_time_stamp
    return round(use_time / 60, 2)


def get_this_month_day(date):
    if date:
        date_list = date.split('-')
        if len(date_list) == 2:
            new_date = calendar.monthrange(int(date_list[0]), int(date_list[1]))
            return '-' + str(new_date[1]) + ' 23:59:59'
