# -*- coding: utf-8 -*-
import datetime
import hashlib
import random
import time

from sqlalchemy.exc import SQLAlchemyError

from Model.Base import db
from Model.Repairs.RepairImagesModel import RepairImage
from Model.Repairs.RepairModel import Repair


class RepairService():

    @staticmethod
    def create(system_users_id, remark, tel, pics, spot_id, machine_id):
        repair = RepairService.createRepairStub(system_users_id, remark, tel, spot_id, machine_id)
        if repair:
            try:
                db.session.add(repair)
                db.session.commit()
            except SQLAlchemyError as e:
                raise e

            if len(pics) > 0:
                for item in pics:
                    repair_images = RepairService.createRepairImage(repair.id, item)
                    if repair_images:
                        try:
                            db.session.add(repair_images)
                            db.session.commit()
                        except SQLAlchemyError as e:
                            raise e
        return repair

    @staticmethod
    def createRepairImage(repair_id, pic):
        repairImage = RepairImage()
        repairImage.repairs_id = repair_id
        repairImage.url = pic
        repairImage.created_at = datetime.datetime.now()
        repairImage.updated_at = datetime.datetime.now()
        return repairImage

    @staticmethod
    def createRepairStub(system_users_id, remark, tel, spot_id, machine_id):
        repair = Repair()
        repair.system_users_id = system_users_id
        repair.remark = remark
        repair.tel = tel
        repair.status = 0
        repair.spot_id = spot_id
        repair.machine_id = machine_id
        repair.created_at = datetime.datetime.now()
        repair.updated_at = datetime.datetime.now()
        return repair

    @staticmethod
    def guid():
        timestamp = int(time.time())
        ranstr = random.randint(9999, 9999999999)
        return RepairService.MD5(str(timestamp) + str(ranstr)) + RepairService.MD5(str(ranstr))[0: 8]

    @staticmethod
    def MD5(info):
        m = hashlib.md5()
        m.update(info.encode("utf-8"))
        return m.hexdigest()
