# -*- coding: utf-8 -*-

from Model.Base import db
from Model.Coupon.CouponOrderModel import CouponOrder
from Model.Coupon.WxGuideModel import WxGuide
from Model.Machine.MachineModel import Machine
from Model.Power.PowerModel import Power
from Model.Production.ProductionModel import Production
from Model.Rent.RentModel import Rent


class IndexService():
    @staticmethod
    def get_total_production(spot_id, start_time, end_time):
        '''
        获取该景区当前时间段内收益和租借充电宝的数量
        :param spot_id:
        :param start_time:
        :param end_time:
        :return:
        '''

        income_info = db.session.query(Production.agent_total).filter(Production.spot_id == spot_id,
                                                                      Production.agent_total > 0,
                                                                      Production.created_at >= start_time,
                                                                      Production.created_at <= end_time).all()
        total = 0
        for info in income_info:
            total += info.agent_total
        return round(total / 100, 2), len(income_info)

    @staticmethod
    def get_total_power(spot_id, start_time, end_time):
        '''
        获取该景区当前时间段内租借充电宝的总量
        :param spot_id:
        :param start_time:
        :param end_time:
        :return:
        '''
        where = {
            Rent.spot_id == spot_id,
            Production.created_at >= start_time,
            Production.created_at <= end_time
        }
        count = db.session.query(Production, Rent).join(Rent, Rent.id == Production.rent_id).filter(*where).count()
        return count

    @staticmethod
    def get_total_production_num(spot_id, start_time, end_time):
        where = {
            Production.is_out == 1,
            Production.spot_id == spot_id,
            Production.created_at >= start_time,
            Production.created_at <= end_time
        }
        count = Production.query.filter(*where).count()
        return count

    @staticmethod
    def get_total_production_finished(spot_id, start_time, end_time):
        '''
        获取已完成的充电宝数量
        :param spot_id:
        :param start_time:
        :param end_time:
        :return:
        '''
        where = {
            Production.is_out == 1,
            Production.is_return == 1,
            Production.total > 0,
            Production.spot_id == spot_id,
            Production.created_at >= start_time,
            Production.created_at <= end_time
        }
        return Production.query.filter(*where).count()

    @staticmethod
    def get_not_return_production(spot_id, start_time, end_time):
        '''
        获取未归还的充电宝数量
        :param spot_id:
        :param start_time:
        :param end_time:
        :return:
        '''
        where = {
            Production.is_return == 0,
            Production.spot_id == spot_id,
            Production.created_at >= start_time,
            Production.created_at <= end_time
        }
        count = Production.query.filter(*where).count()
        return count

    @staticmethod
    def get_invalid_production(spot_id, start_time, end_time):
        '''
        获取无效的充电宝数量
        :param spot_id:
        :param start_time:
        :param end_time:
        :return:
        '''
        where = {
            Production.is_out == 1,
            Production.is_return == 1,
            Production.total <= 0,
            Production.spot_id == spot_id,
            Production.created_at >= start_time,
            Production.created_at <= end_time
        }
        return Production.query.filter(*where).count()

    @staticmethod
    def get_invalid_production_info(spot_id, start_time, end_time):
        '''
        获取无效的充电宝信息
        :param spot_id:
        :param start_time:
        :param end_time:
        :return:
        '''
        where = {
            Production.is_return == 1,
            Production.spot_id == spot_id,
            Production.total == 0,
            Production.created_at >= start_time,
            Production.created_at <= end_time
        }
        total = 0
        infos = db.session.query(Rent.one_day_price).join(Production, Production.rent_id == Rent.id).filter(
            *where).all()
        for info in infos:
            total += info.one_day_price
        return round(total / 100, 2), len(infos)

    @staticmethod
    def get_invalid_production_info_all(spot_id):
        '''
        获取当前景区所有的无效充电宝信息
        :param spot_id:
        :return:
        '''
        where = {
            Production.is_return == 1,
            Production.spot_id == spot_id,
            Production.total == 0
        }
        total = 0
        infos = db.session.query(Rent.one_day_price).join(Production, Production.rent_id == Rent.id).filter(
            *where).all()
        for info in infos:
            total += info.one_day_price
        return round(total / 100, 2), len(infos)

    @staticmethod
    def get_refund_rent(spot_id, start_time, end_time):
        info = db.session.query(Production, Rent).join(Rent, Rent.id == Production.rent_id).filter(
            Production.spot_id == spot_id, Production.is_refund == 1, Production.return_hatch_no == 127,
            Production.refund_time >= start_time, Production.refund_time <= end_time).all()
        total_income = 0
        for i in info:
            total_income += i.Production.agent_total
        return round(total_income / 100, 2), len(info)

    @staticmethod
    def get_history_refund_rent(spot_id):
        info = db.session.query(Production, Rent).join(Rent, Rent.id == Production.rent_id).filter(
            Production.spot_id == spot_id, Production.is_refund == 1, Production.return_hatch_no == 127).all()
        total_income = 0
        for i in info:
            total_income += i.Production.agent_total
        return round(total_income / 100, 2), len(info)

    @staticmethod
    def get_history_income_production(spot_id):
        '''
        获取历史收益通过production
        :param spot_id:
        :return:
        '''
        # total = db.session.query(func.sum(Production.total)).filter(Production.spot_id == spot_id).scalar()
        # logger.info(total)
        # return round(total / 100, 2)

        total = 0
        income_info = db.session.query(Production.agent_total).filter(Production.spot_id == spot_id,
                                                                      Production.agent_total > 0).all()
        for info in income_info:
            total += info.agent_total
        return round(total / 100, 2)

    @staticmethod
    def get_history_production(spot_id):
        '''
        获取历史租借充电宝数量
        :param spot_id:
        :return:
        '''
        where = {
            Production.is_out == 1,
            Production.is_return == 1,
            Production.total > 0,
            Production.spot_id == spot_id
        }
        total = Production.query.filter(*where).count()
        return total

    @staticmethod
    def get_available_power_number(machine_id):
        power_info = Power.query.filter(Power.has_power > 75, Power.status == 2, Power.machine_id == machine_id).count()
        return power_info

    @staticmethod
    def get_machine_total_power(machine_id):
        total = 55
        power_info = Power.query.filter_by(machine_id=machine_id).all()
        for power in power_info:
            if power.power_no.startswith("00000000"):
                total -= 1
        return total

    @staticmethod
    def get_machine_info(spot_id):
        machine_info = Machine.query.filter(Machine.spot_id == spot_id).all()
        machine = []
        for info in machine_info:
            cur_machine = {}
            cur_machine['mac_no'] = info.mac_no
            cur_machine['life'] = info.life
            cur_machine['hatch_number'] = IndexService.get_machine_total_power(info.id)
            cur_machine['take_out_tool'] = info.take_out_tool
            cur_machine['available_number'] = IndexService.get_available_power_number(info.id)
            machine.append(cur_machine)

        return machine

    @staticmethod
    def get_discount_money(spot_id, start_time, end_time):
        discount_info = db.session.query(CouponOrder, WxGuide).join(WxGuide,
                                                                    WxGuide.id == CouponOrder.wx_guide_id).filter(
            CouponOrder.spot_id == spot_id, CouponOrder.updated_at >= start_time,
            CouponOrder.updated_at <= end_time).all()
        total = 0
        for info in discount_info:
            total += info.WxGuide.bonus

        return round(total / 100, 2)
