# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, Index, DateTime, FetchedValue, Date
from Model.Base import BaseModel


class CouponOrder(BaseModel):
    __tablename__ = 'coupon_order'
    __table_args__ = (
        Index('wx_guide_id_customer_id', 'wx_guide_id', 'customer_id'),
    )

    id = Column(Integer, primary_key=True)
    spot_id = Column(Integer, comment='景点id')
    business_id = Column(Integer, comment='商户id')
    coupon_type_id = Column(Integer, nullable=False, comment='优惠券id')
    wx_guide_id = Column(Integer, comment='对应导游的id')
    customer_id = Column(Integer, comment='用户的id')
    status = Column(Integer, nullable=False, server_default=FetchedValue(), comment='领取状态，1代表领取，2代表使用过，3过期')
    add_time = Column(DateTime, nullable=False, server_default=FetchedValue(), comment='用户领取时间')
    expire_time = Column(Date, nullable=False, comment='优惠的过期时间')
