# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, String, DateTime, FetchedValue
from Model.Base import BaseModel


class Production(BaseModel):
    __tablename__ = 'production'

    id = Column(Integer, primary_key=True)
    rent_id = Column(Integer, nullable=False, comment='租借id')
    is_out = Column(Integer, nullable=False, server_default=FetchedValue(), comment='是否取出')
    power_id = Column(Integer, nullable=False, comment='讲解器id')
    power_no = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='讲解器编号')
    rent_machine_id = Column(Integer, nullable=False, comment='租的机柜id')
    rent_hatch_no = Column(Integer, nullable=False, comment='租的仓口')
    is_return = Column(Integer, nullable=False, server_default=FetchedValue(), comment='是否归还')
    return_machine_id = Column(Integer, comment='还的机柜id')
    return_hatch_no = Column(Integer, comment='还的仓口')
    return_time = Column(DateTime, comment='还的时间')
    agent_return_time = Column(DateTime, comment='代理商看的归还的时间')
    is_refund = Column(Integer, nullable=False, server_default=FetchedValue(), comment='是否退款')
    refund_no = Column(String(191, 'utf8mb4_unicode_ci'), comment='退款单号')
    refund_time = Column(DateTime, comment='代理商看的退款的时间')
    agent_refund_time = Column(DateTime, comment='退款时间')
    total = Column(Integer, comment='消费金额')
    agent_total = Column(Integer, comment='代理商看的收入')
    spot_id = Column(Integer, nullable=False, comment='景点id')
    business_id = Column(Integer, nullable=False, comment='商家id')
