# -*- coding: utf-8 -*-
from xpinyin import Pinyin
from Config.common_config import ACCOUNT_STATUS
from Model.Agent.AgentAccountModel import AgentAccount
from Model.Agent.AgentSpotModel import AgentSpot
from Model.Base import db
from Model.Machine.MachineModel import Machine
from Model.Spot.SpotModel import Spot


class SpotService():
    @staticmethod
    def get_spot_info():
        infos = []
        spot_info = Spot.query.with_entities(Spot.spotname, Spot.id).all()
        for info in spot_info:
            cur_info = {}
            cur_info['id'] = info.id
            cur_info['letter'] = SpotService.get_pinyin(info.spotname)
            cur_info['spotname'] = info.spotname
            cur_info['agent_info'] = SpotService.get_agent_spot(info.id)
            infos.append(cur_info)

        return infos

    @staticmethod
    def get_agent_spot(spot_id):
        agent_spot = db.session.query(AgentSpot, AgentAccount).join(AgentAccount,
                                                                    AgentAccount.id == AgentSpot.agent_no).filter(
            AgentSpot.spot_no == spot_id, AgentAccount.status == ACCOUNT_STATUS['on_use'],
            AgentSpot.status == ACCOUNT_STATUS['on_use']).all()
        total_info = []
        for info in agent_spot:
            cur_info = {}
            cur_info['agent_name'] = info.AgentAccount.user_name
            cur_info['phone'] = info.AgentAccount.phone
            cur_info['comment'] = info.AgentAccount.comment
            cur_info['spot_info'] = SpotService.get_spot_agent(info.AgentAccount.id)
            total_info.append(cur_info)
        return total_info

    @staticmethod
    def get_spot_agent(agent_id):
        spot_agent = db.session.query(AgentAccount, AgentSpot, Spot).join(AgentSpot,
                                                                          AgentAccount.id == AgentSpot.agent_no).join(
            Spot, Spot.id == AgentSpot.spot_no).filter(AgentAccount.id == agent_id,
                                                       AgentAccount.status == ACCOUNT_STATUS['on_use'],
                                                       AgentSpot.status == ACCOUNT_STATUS['on_use']).all()
        total_info = []
        for info in spot_agent:
            cur_info = {}
            cur_info['spot_id'] = info.Spot.id
            cur_info['spot_name'] = info.Spot.spotname
            total_info.append(cur_info)
        return total_info

    @staticmethod
    def get_pinyin(word):
        s = Pinyin().get_initials(word)
        return s[0:1].upper()

    @classmethod
    def get_spot_machine_list(cls, spot_id):

        res = Machine.query.filter_by(spot_id=spot_id).all()
        if res:
            result = []
            for i in res:
                tmp = {
                    "id": i.id,
                    "mac_no": i.mac_no
                }
                result.append(tmp)
            return result
        else:
            return []
