# -*- coding: utf-8 -*-
from flask import Blueprint, jsonify, g, request

from Libs.ErrorTips import BASE_RESPONSE
from Service.SpotService import SpotService

route_spot = Blueprint('spot', __name__)


@route_spot.route('/spot_info')
def all_spot_info():
    info = SpotService.get_spot_info()
    return jsonify(BASE_RESPONSE(data=info).to_dict())


@route_spot.route('/spot_machine_list', methods=["POST"])
def get_spot_machine_list():
    json_data = request.get_json()
    spot_id = json_data.get("spot_id")
    info = SpotService.get_spot_machine_list(spot_id)
    return jsonify(BASE_RESPONSE(data=info).to_dict())
