# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, String, FetchedValue
from Model.Base import BaseModel


class Spot(BaseModel):
    __tablename__ = 'spot'

    id = Column(Integer, primary_key=True)
    spotname = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='景点名')
    business_id = Column(Integer, nullable=False, comment='关联id')
    main_title = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='主标题')
    vic_title = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='副标题')
    detail_img = Column(String(191, 'utf8mb4_unicode_ci'), comment='展示界面的图片')
    wx_logo = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='微信头像')
    go_url = Column(String(191, 'utf8mb4_unicode_ci'), comment='定制化界面')
    listen_img = Column(String(191, 'utf8mb4_unicode_ci'), comment='手机游二维码')
    page_id = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='微信id')
    code = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='唯一值')
    time = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='开始时间')
    overtime = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='结束时间')
    open_week = Column(String(255), server_default=FetchedValue(), comment='营业时间')
    address = Column(String(255), nullable=False, server_default=FetchedValue())
    return_img = Column(String(255, 'utf8mb4_unicode_ci'), comment='归还图片')
    spotname_english = Column(String(191, 'utf8mb4_unicode_ci'), comment='景点英文名')
