# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, String, FetchedValue, DateTime

from Config.common_config import AGENT_STATUS
from Model.Base import BaseModel


class AgentAccount(BaseModel):
    __tablename__ = 'agent_account'

    id = Column(Integer, primary_key=True)
    agent_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    user_name = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False)
    phone = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, server_default=FetchedValue())
    level = Column(Integer, nullable=False, server_default=FetchedValue(), comment='1:超级管理员， 2：代理商')
    status = Column(Integer, nullable=False, server_default=FetchedValue(), comment='1:正常 2：删除')
    access_token = Column(String(255, 'utf8mb4_unicode_ci'))
    salt = Column(String(255, 'utf8mb4_unicode_ci'))
    password = Column(String(255, 'utf8mb4_unicode_ci'))
    salt_pwd = Column(String(255, 'utf8mb4_unicode_ci'))
    comment = Column(String(255, 'utf8mb4_unicode_ci'))
    last_login = Column(DateTime)
    expire_time = Column(DateTime)

    @property
    def level_desc(self):
        return AGENT_STATUS[str(self.level)]
